/*
 * Character counter plugin.  Requires the following to be specified in the CKEdit config:
 *		extraPlugins: 		'charCount'
 *
 * Also supports the following configuration options:
 *
 * 		charCountRefresh:		How often the count is refreshed, in milliseconds.  Defaults to 1000.
 * 		charCountPlainText:		Set to true if the character count should apply to plain text characters,
 * 								and false if it should apply to the entire HTML length.  (Defaults to false.)
 * 		charCountLimit:			The upper limit for this field, which will be substituted into the format
 * 								value to replace %limit%.
 * 		charCountFormat:		The format to use when writing our the character count.  The values %count%
 * 								and %limit% will be replaced by the current count and the charCountLimit
 * 								(respectively).  The default is:
 * 								'<span class="cke_charcount_count">%count%</span> of <span class="cke_charcount_limit">%limit%</span> characters'
 * 
 * 		charCountLimitUIColor:	The UI color to use when the edit field has reached its character limit.
 * 								(Defaults to 'unchanged'.)
 * 
 * If the limit is reached, the 'cke_charcount_count' field will be wrapped with the class
 * 'cke_charcount_count_over_limit'.  You can use this to define a different appearance for the character
 * count when the limit has been reached.
 */
CKEDITOR.plugins.add('charCount',
{
	init: function(editor) {
				var		classNameLimitReached = 'cke_charcount_count_over_limit';

				var		defaultRefresh = 1000;
				var		defaultLimit = 'unlimited';
				var		defaultFormat = '<span class="cke_charcount_count">%count%</span> of <span class="cke_charcount_limit">%limit%</span> characters';
				var		defaultLimitUIColor = null;

				var		refresh = defaultRefresh;
				var		limit = defaultLimit;
				var		format = defaultFormat;
				var		countPlainText = false;
				var		limitUIColor = defaultLimitUIColor;

				var		intervalId;
				var		lastCount = 0;
				var		limitReachedNotified = false;
				var		limitRestoredNotified = false;

				var		standardUiColor = null;		/* Will be grabbed when necessary. */
		      
				if (true) {  
					function counterId(editor) {
						return 'cke_charcount_' + editor.name;
					}

					function counterElement(editor) {
						return document.getElementById(counterId(editor));
					}

					function getUiColor(editor) {
						var		standardUiColor = editor.getUiColor();
						
						if (!standardUiColor) {
							var		$frame = $('.cke_editor_' + editor.name + ' .cke_wrapper');

							standardUiColor = $frame.css('background-color');
						}
						
						return standardUiColor;
					}

					function updateCounter(editor) {
						var		htmlData = editor.getData();
						var		dataLen = countPlainText ? htmlData.length : htmlData.plainTextLength(true);
		
						if (dataLen == lastCount) {
							return true;
						} 
		          	  	else {
		          	  		lastCount = dataLen;
		          	  	}
		            
						if (!limitReachedNotified && (dataLen > limit)) {
							limitReached(editor);
						}
						else if (!limitRestoredNotified && (dataLen <= limit)) {
							limitRestored(editor);
						}

						var		html = format.replace('%count%', dataLen).replace('%limit%', limit);
		
						counterElement(editor).innerHTML = html;
					}

					function limitReached(editor) {
						var		$charCount = $('#' + counterId(editor));

						limitReachedNotified = true;
						limitRestoredNotified = false;
						
						if (limitUIColor) {
							editor.setUiColor(limitUIColor);
						}

						$charCount.addClass(classNameLimitReached);
					}

					function limitRestored(editor) {
						var		$charCount = $('#' + counterId(editor));

						limitRestoredNotified = true;
						limitReachedNotified = false;

						if (standardUiColor) {
							editor.setUiColor(standardUiColor);
						}

						$charCount.removeClass(classNameLimitReached);
					}
		
					editor.on('themeSpace', function(event) {
													if (event.data.space == 'bottom') {
														event.data.html += '<div id="' + counterId(event.editor) + 
																		   '" class="cke_charcount"' +
																		   ' title="' + 
																		   CKEDITOR.tools.htmlEncode( 'Character Counter' ) + '"' +
																		   '>&nbsp;</div>';
										            }
												}, editor, null, 100);

					editor.on('instanceReady', function(event) {
														standardUiColor = getUiColor(editor);

											            if (editor.config.charCountRefresh) {
											            	refresh = editor.config.charCountRefresh;
											            }
		
											            if (editor.config.charCountLimit) {
											               limit = editor.config.charCountLimit;
											            }
							
											            if (editor.config.charCountFormat) {
											               format = editor.config.charCountFormat;
											            }

											            if (editor.config.charCountPlainText) {
											            	countPlainText = editor.config.charCountPlainText;
											            }

											            if (editor.config.charCountLimitUIColor) {
											            	limitUIColor = editor.config.charCountLimitUIColor;
											            }
													}, editor, null, 100);
		         
					editor.on('dataReady', function(event) {
													var		htmlData = event.editor.getData();
										            var		dataLen = countPlainText ? htmlData.length :
										            								   htmlData.plainTextLength(true);
						
										            if (dataLen > limit) {
										               limitReached(editor);
										            }

										            updateCounter(event.editor);
												}, editor, null, 100);

					editor.on('key', function(event) {
						        	 				// updateCounter(event.editor);
						         				}, editor, null, 100 );
		         
					editor.on('focus', function(event) {
										            editorHasFocus = true;
										            intervalId = window.setInterval( function() {
															            						updateCounter(editor);
																					    	}, refresh, event.editor);
												}, editor, null, 100);
		
					editor.on( 'blur', function(event) {
													editorHasFocus = false;
										            if (intervalId) {
										            	clearInterval(intervalId);
										            }
												}, editor, null, 100 );
				}
			}
});
